## Installation
1. Install [PyTorch](https://github.com/pytorch/examples/blob/master/imagenet).
2. Install the required python packages. All packages can be installed by running the following command:
```bash
pip install -r requirements.txt
```
3. Download and prepare the ImageNet dataset. You can use [this script](https://raw.githubusercontent.com/soumith/imagenetloader.torch/master/valprep.sh), 
provided by the PyTorch repository, to move the validation subset to the labeled subfolders.
4. Prepare resized versions of the ImageNet dataset, you can use `resize.py` provided in this repository. 
5. Install [Apex](https://github.com/NVIDIA/apex) to use half precision speedup. 

## Training a model
Scripts to robustly train an ImageNet classifier for epsilon radii of 2/255 and 4/255 are provided in `run_fast_2px.sh` , `run_fast_2px_bat.sh` and `run_fast_4px.sh`, `run_fast_4px_bat.sh`. These run the main code module `main_free.py` using the configurations provided in the `configs/` folder. To run the 50 step PGD adversary with 10 restarts, we also provide `run_eval.sh`. All parameters can be modified by adjusting the configuration files in the `configs/` folder. 